/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.launcher.loading;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Color;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import technology.rocketjump.undermount.environment.model.SunlightPhase;

public class SunlightPhaseParser {
    private FileHandle jsonFile;

    public SunlightPhaseParser(FileHandle sunlightJsonFile) {
        this.jsonFile = sunlightJsonFile;
    }

    public List<SunlightPhase> parseSunlightPhases() throws IOException {
        LinkedList<SunlightPhase> results = new LinkedList<SunlightPhase>();
        JSONObject sunlightJson = JSON.parseObject(FileUtils.readFileToString(this.jsonFile.file(), "UTF-8"));
        HashMap<String, Color> namedColors = new HashMap<String, Color>();
        JSONObject colorDefinitions = sunlightJson.getJSONObject("colors");
        for (String colorName : colorDefinitions.keySet()) {
            JSONArray colorValues = colorDefinitions.getJSONArray(colorName);
            namedColors.put(colorName.toLowerCase(), new Color((float)colorValues.getIntValue(0) / 255.0f, (float)colorValues.getIntValue(1) / 255.0f, (float)colorValues.getIntValue(2) / 255.0f, 1.0f));
        }
        JSONArray phasesJsonArray = sunlightJson.getJSONArray("phases");
        for (int index = 0; index < phasesJsonArray.size(); ++index) {
            JSONObject phaseJson = phasesJsonArray.getJSONObject(index);
            results.add(new SunlightPhase(phaseJson.getFloatValue("time"), (Color)namedColors.get(phaseJson.getString("color").toLowerCase())));
        }
        return results;
    }
}

